#!/bin/bash
#
# Tool to repeatedly obtain 1000 samples of performance data and obtain the
# lowest value
#
# Written by Stephan Mueller <smueller@chronox.de>
#

DIR="results"
FILE="$DIR/duration_data"
CALL="../getrawentropy -s 1000 -f /sys/kernel/debug/lrng_testing/lrng_irq_perf"
R="Rscript --vanilla get_mean.r"

MIN=10000

if [ ! -d "$DIR" ]
then
	mkdir $DIR
fi

i=0
while [ $i -lt 1000 ]
do
	$($CALL > $FILE)
	curr_time=$($R $FILE 2>&1)

	echo $MIN $curr_time
	smaller=$(echo "$MIN > $curr_time" | bc)
	if [ $smaller -ne 0 ]
	then
		MIN=$curr_time
		mv $FILE $FILE.smallest
	fi

	i=$((i+1))
done

echo $MIN
