/*
 * Copyright (C) 2017 - 2019, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#ifndef _CIPHER_DEFINITIONS_H
#define _CIPHER_DEFINITIONS_H

#ifdef __cplusplus
extern "C"
{
#endif

/* AES */
#define ACVP_ECB		0x0000000000000001ULL
#define ACVP_CBC		0x0000000000000002ULL
#define ACVP_XTS		0x0000000000000003ULL
#define ACVP_OFB		0x0000000000000004ULL
#define ACVP_CFB1		0x0000000000000005ULL
#define ACVP_CFB8		0x0000000000000006ULL
#define ACVP_CFB128		0x0000000000000007ULL
#define ACVP_KW			0x0000000000000008ULL
#define ACVP_KWP		0x0000000000000009ULL
#define ACVP_CTR		0x000000000000000aULL
#define ACVP_AES128		0x000000000000000bULL	/* only used for DRBG */
#define ACVP_AES192		0x000000000000000cULL	/* only used for DRBG */
#define ACVP_AES256		0x000000000000000dULL	/* only used for DRBG */
#define ACVP_CBC_CS1		0x000000000000000eULL
#define ACVP_CBC_CS2		0x0000000000000010ULL
#define ACVP_CBC_CS3		0x0000000000000020ULL
#define ACVP_AESMASK		0x00000000000000ffULL

/* TDES */
#define ACVP_TDESECB		0x0000000000000100ULL
#define ACVP_TDESCBC		0x0000000000000200ULL
#define ACVP_TDESOFB		0x0000000000000300ULL
#define ACVP_TDESCFB1		0x0000000000000400ULL
#define ACVP_TDESCFB8		0x0000000000000500ULL
#define ACVP_TDESCFB64		0x0000000000000600ULL
#define ACVP_TDESCTR		0x0000000000000700ULL
#define ACVP_TDESKW		0x0000000000000800ULL
#define ACVP_TDESMASK		0x0000000000000f00ULL

#define ACVP_SYMMASK		0x0000000000000fffULL

/* parser_aead.c requires the ability of ORing these flags */
#define ACVP_GCM 		0x0000000000001000ULL
#define ACVP_CCM 		0x0000000000002000ULL
#define ACVP_GCMSIV		0x0000000000004000ULL
#define ACVP_AEADMASK		0x000000000000f000ULL

#define ACVP_HMACSHA1 		0x0000000000030000ULL
#define ACVP_HMACSHA2_224 	0x0000000000040000ULL
#define ACVP_HMACSHA2_256 	0x0000000000050000ULL
#define ACVP_HMACSHA2_384 	0x0000000000060000ULL
#define ACVP_HMACSHA2_512	0x0000000000070000ULL
#define ACVP_HMACSHA2_512224	0x0000000000080000ULL
#define ACVP_HMACSHA2_512256	0x0000000000090000ULL
#define ACVP_HMACSHA3_224 	0x00000000000a0000ULL
#define ACVP_HMACSHA3_256 	0x00000000000b0000ULL
#define ACVP_HMACSHA3_384 	0x00000000000c0000ULL
#define ACVP_HMACSHA3_512	0x00000000000d0000ULL
#define ACVP_HMACMASK		0x00000000000f0000ULL

#define ACVP_SHA1 		0x0000000000100000ULL
#define ACVP_SHA224 		0x0000000000200000ULL
#define ACVP_SHA256 		0x0000000000300000ULL
#define ACVP_SHA384 		0x0000000000400000ULL
#define ACVP_SHA512 		0x0000000000500000ULL
#define ACVP_SHA512224		0x0000000000600000ULL
#define ACVP_SHA512256		0x0000000000700000ULL
#define ACVP_SHA3_224 		0x0000000000800000ULL
#define ACVP_SHA3_256 		0x0000000000900000ULL
#define ACVP_SHA3_384 		0x0000000000a00000ULL
#define ACVP_SHA3_512 		0x0000000000b00000ULL
#define ACVP_HASHMASK		0x0000000000f00000ULL

#define ACVP_NISTP224		0x0000000001000000ULL
#define ACVP_NISTP256		0x0000000002000000ULL
#define ACVP_NISTP384		0x0000000003000000ULL
#define ACVP_NISTP521		0x0000000004000000ULL
#define ACVP_NISTK233		0x0000000005000000ULL
#define ACVP_NISTK283		0x0000000006000000ULL
#define ACVP_NISTK409		0x0000000007000000ULL
#define ACVP_NISTK571		0x0000000008000000ULL
#define ACVP_NISTB233		0x0000000009000000ULL
#define ACVP_NISTB283		0x000000000a000000ULL
#define ACVP_NISTB409		0x000000000b000000ULL
#define ACVP_NISTB571		0x000000000c000000ULL
#define ACVP_ED25519		0x000000000d000000ULL
#define ACVP_ED448		0x000000000e000000ULL
#define ACVP_CURVEMASK		0x000000000f000000ULL

#define ACVP_ECDH 		0x0000000010000000ULL
#define ACVP_DH2048224 		0x0000000020000000ULL
#define ACVP_DH2048256		0x0000000030000000ULL
#define ACVP_RSA		0x0000000040000000ULL
#define ACVP_ECDSA		0x0000000080000000ULL
#define ACVP_DSA		0x0000000100000000ULL
#define ACVP_DH			0x0000000200000000ULL
#define ACVP_EDDSA		0x0000000400000000ULL

#define ACVP_DRBGCTR		0x0000001000000000ULL
#define ACVP_DRBGHMAC		0x0000002000000000ULL
#define ACVP_DRBGHASH		0x0000003000000000ULL
#define ACVP_DRBGMASK		0x000000f000000000ULL

#define ACVP_AESCMAC 		0x0000010000000000ULL
#define ACVP_TDESCMAC		0x0000020000000000ULL
#define ACVP_CMACMASK		0x00000f0000000000ULL

#define ACVP_KDF_COMPONENT	0x0000100000000000ULL
#define ACVP_KDF_800_108	0x0000200000000000ULL
#define ACVP_KDF_MASK		0x0000f00000000000ULL

#define ACVP_KDF_108_DOUBLE_PIPELINE	0x0001000000000000ULL
#define ACVP_KDF_108_FEEDBACK		0x0002000000000000ULL
#define ACVP_KDF_108_COUNTER		0x0004000000000000ULL

#define ACVP_KDF_108_AFTER_FIXED	0x0010000000000000ULL
#define ACVP_KDF_108_BEFORE_FIXED	0x0020000000000000ULL
#define ACVP_KDF_108_MIDDLE_FIXED	0x0040000000000000ULL
#define ACVP_KDF_108_BEFORE_ITERATOR	0x0080000000000000ULL

#define ACVP_SHAKE128		0x0100000000000000ULL
#define ACVP_SHAKE256		0x0200000000000000ULL
#define ACVP_SHAKEMASK		0x0300000000000000ULL

#define ACVP_UNKNOWN		0x0000000000000000ULL

#ifdef __cplusplus
}
#endif

#endif /* _CIPHER_DEFINITIONS_H */
