#!/bin/bash
#
# CAVS test executor
# Written and Copyright (c) by: Stephan Müller <smueller@chronox.de>
#
# License: see LICENSE file
#
#                            NO WARRANTY
#
#    BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
#    FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
#    OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
#    PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
#    OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
#    MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
#    TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
#    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
#    REPAIR OR CORRECTION.
#
#    IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
#    WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
#    REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
#    INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
#    OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
#    TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
#    YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
#    PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
#    POSSIBILITY OF SUCH DAMAGES.

. $(dirname $0)/exec_lib.sh

TARGET="openssl"

MODULE_PREFIX="OpenSSL_"
MODULE_POSTFIX="_"

EXEC_TYPES="_64_bit___ _32_bit___"

EXEC_TYPES__64_bit___=""
EXEC_TYPES__32_bit___="CFLAGS=-m32 LDFLAGS=-m32"

EXEC_TYPES_DRBG10X__64_bit___="CFLAGS=-DOPENSSL_DRBG_10X"
EXEC_TYPES_DRBG10X__32_bit___="CFLAGS=\"-m32 -DOPENSSL_DRBG_10X\" LDFLAGS=-m32"

EXEC="TDES_C
      AESNI AESNI_AVX AESNI_CLMULNI AESNI_ASM
      AESASM AESASM_AVX AESASM_CLMULNI AESASM_ASM
      BAES_CTASM BAES_CTASM_AVX BAES_CTASM_CLMULNI BAES_CTASM_ASM
      SHA_AVX2 SHA_AVX SHA_SSSE3 SHA_ASM SHA3_AVX2 SHA3_ASM SHA3_AVX512"

EXEC_DRBG10X="AESNI AESASM BAES_CTASM SHA_AVX2 SHA_AVX SHA_SSSE3 SHA_ASM"

# Assembler cipher and C block chaining modes
CIPHER_CALL_TDES_C=""

CIPHER_CALL_AESNI=""				# used by default
CIPHER_CALL_AESNI_AVX="" #OPENSSL_ia32cap=??"	# fips.c clears the bit #60
CIPHER_CALL_AESNI_CLMULNI=""			# used by default
CIPHER_CALL_AESNI_ASM="OPENSSL_ia32cap=~0x01000000:0x0"

CIPHER_CALL_AESASM="OPENSSL_ia32cap=~0x200020200000000:0x0"
CIPHER_CALL_AESASM_AVX="" #OPENSSL_ia32cap=??"	# fips.c clears the bit #60
CIPHER_CALL_AESASM_CLMULNI="OPENSSL_ia32cap=~0x200020000000000:0x0"
CIPHER_CALL_AESASM_ASM="OPENSSL_ia32cap=~0x200020200000000:0x0"

CIPHER_CALL_BAES_CTASM="OPENSSL_ia32cap=~0x200000000000000:0x0"
CIPHER_CALL_BAES_CTASM_AVX="" #OPENSSL_ia32cap=??"	# fips.c clears the bit #60
CIPHER_CALL_BAES_CTASM_CLMULNI="OPENSSL_ia32cap=~0x200000000000000:0x0"
CIPHER_CALL_BAES_CTASM_ASM="OPENSSL_ia32cap=~0x200000200000000:0x0"

CIPHER_CALL_SHA3_AVX512=""			#TODO: unknown setting
CIPHER_CALL_SHA_AVX2=""				# used by default
CIPHER_CALL_SHA3_AVX2=$CIPHER_CALL_SHA_AVX2
CIPHER_CALL_SHA_AVX="" #OPENSSL_ia32cap=??"	# fips.c clears the bit #60
CIPHER_CALL_SHA_SSSE3="OPENSSL_ia32cap=:~0x20:0x0"
CIPHER_CALL_SHA_ASM="OPENSSL_ia32cap=~0x0000020000000000:~0x20"
CIPHER_CALL_SHA3_ASM=$CIPHER_CALL_SHA_ASM

################### Heavy Lifting #######################

do_test() {
	PATH=.:$PATH

	for type in $EXEC_TYPES; do
		eval BUILD_FLAGS=\$EXEC_TYPES_$type

		eval "$BUILD_FLAGS build_tool ${TARGET}"

		for exec in $EXEC; do
			eval CIPHER_CALL=\$CIPHER_CALL_$exec

			local modulename="${MODULE_PREFIX}${type}${exec}${MODULE_POSTFIX}"

			eval "$CIPHER_CALL exec_module ${modulename}"
		done

		make clean
	done
}

do_test_drbg10x() {
	PATH=.:$PATH

	for type in $EXEC_TYPES; do
		eval BUILD_FLAGS=\$EXEC_TYPES_DRBG10X_$type

		eval "$BUILD_FLAGS build_tool ${TARGET}"

		for exec in $EXEC_DRBG10X; do
			eval CIPHER_CALL=\$CIPHER_CALL_$exec

			local modulename="${MODULE_PREFIX}${type}DRBG_10X_${exec}${MODULE_POSTFIX}"

			eval "$CIPHER_CALL exec_module ${modulename}"
		done

		make clean
	done
}

do_test
do_test_drbg10x
exit $failures
