﻿/*
 * Copyright (C) 2019, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#undef _FORTIFY_SOURCE
#pragma GCC optimize ("O0")

#define _GNU_SOURCE
#include <unistd.h>
#include <sys/syscall.h>
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <errno.h>
#include <limits.h>
#include <stdlib.h>
#include <inttypes.h>

#include "jitterentropy-base.c"

int main(int argc, char *argv[])
{
	uint64_t i;
	struct rand_data ec;

	(void)argc;
	(void)argv;

	memset(&ec, 0, sizeof(ec));

	printf("Test performed on %" PRIx64 "\n", ec.data);

	for (i = 1; i <= 1000000; i++) {
		jent_lfsr_time(&ec, i, 1, 0);
		fprintf(stderr, "Pool state after %" PRIx64 " full LFSR ops: %" PRIx64 "\n", i, ec.data);
		fwrite(&ec.data, sizeof(uint64_t), 1, stdout);
	}

	/* print out the final content of the pool -- it is now zero */
	fprintf(stderr, "Pool state after %" PRIx64 " full LFSR ops: %" PRIx64 "\n", i, ec.data);

	return 0;
}
