#!/bin/bash

CWD=$(pwd)
RESULTSDIR="${CWD}/test_results"

. ./libtest.sh

init()
{
	if [ ! -d ${RESULTSDIR} ]
	then
		mkdir ${RESULTSDIR}
		if [ $? -ne 0 ]
		then
			echo_fail "Cannot create results directory ${RESULTSDIR}"
			exit 1
		fi
	fi
}

# chi_squared()
# {
# 	echo_info "Processing Chi-Squared Test"
#
# 	cd chi_squared
# 	make -s
# 	./jitterentropy-chi-squared > ${RESULTSDIR}/chi_squared.out
#
# 	if [ $? -eq 0 ]
# 	then
# 		echo_pass "Chi-Squared Test"
# 	else
# 		echo_fail "Chi-Squared Test"
# 	fi
# 	make clean
# }
#
# health_tests()
# {
# 	echo_info "Processing Health Test"
#
# 	cd health_tests
# 	make -s
# 	./jitterentropy-health > ${RESULTSDIR}/health_tests.out
#
# 	if [ $? -eq 0 ]
# 	then
# 		echo_pass "Health Test"
# 	else
# 		echo_fail "Health Test"
# 	fi
#
# 	make clean
# }

lfsr_tests()
{
	echo_info "Processing LFSR Test"

	cd lfsr-tests/userspace
	make -s
	./jitterentropy-lfsr 2>${RESULTSDIR}/lfsr_tests.ascii > ${RESULTSDIR}/lfsr_tests.bin

	echo_info "Analyze LFSR Test results yourself"

	make clean
}

raw_entropy()
{
	echo_info "Processing Raw Entropy Test"

	cd raw-entropy/recording_userspace

	./invoke_testing.sh

	mv ../results-measurements ${RESULTSDIR}

	echo_info "Analyze Raw Entropy Test results yourself"
}

init
# chi_squared
# cd ${CWD}
# health_tests
# cd ${CWD}
lfsr_tests
cd ${CWD}
raw_entropy
